/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	WindowView.h
	
	Contains:	Class definition and includes for a BView
				subclass that looks like a BWindow.
	
	   Notes:	None.
	   
   ............................................................... */

#ifndef _WINDOW_VIEW_H
#define _WINDOW_VIEW_H

#ifndef _VIEW_H
#include <View.h>
#endif

#ifndef _WINDOW_COLORS_H
#include "WindowColors.h"
#endif

#ifndef _COLOR_LABEL_H
#include "ColorLabel.h"
#endif

#ifndef _WINDOW_COLORS_PANEL_H
#include "WindowColorsPanel.h"
#endif


/* ...............................................................	
	Constants
   ............................................................... */

const float 	TAB_HEIGHT = 19;
const BRect		DIVOT_LABEL_FRAME = BRect(16, 60, 120, 77);
const BRect		CLOSE_BOX_BOUNDS = BRect(4, 4, 17, 17);
const BPoint	FRAME_DIVOT_ORIGIN = BPoint(128, 60);
const BPoint	MODAL_FRAME_DIVOT_ORIGIN = BPoint(16, 41);


/* ...............................................................	
	WindowView class
   ............................................................... */

class WindowColorsPanel;
class WindowView : public BView
{
	public:
						WindowView(BRect frame,
								   const char *name, 
								   window_type look);
								   
			void		Draw(BRect updateRect);
			void		MouseDown(BPoint where);
			void		AttachedToWindow();
			void		MessageReceived(BMessage *message);

			bool		IsActive();
			void		Activate(bool flag);
			void		Update();
			
	WindowColorsPanel	*ParentPanel();

	private:
	
			BRect		_tabBounds;
			window_type	_look;
			bool		_active;
};

#endif